precision mediump float;

//declare uniforms
uniform sampler2D u_diffuseTexture;
uniform sampler2D _DisplacementTex;
uniform float _DisplacementPowerX;
uniform float _DisplacementPowerY;
uniform vec2 _textureSize;
uniform vec2 _texelSize;

//"in" attributes from our vertex shader
varying vec4 v_color;
varying vec2 v_texCoords;

void main() {
	vec2 displacementPower = vec2(-1.0 * _DisplacementPowerX * _texelSize.x, -1.0 * _DisplacementPowerY * _texelSize.y);
	vec4 mapColor = texture2D(_DisplacementTex, v_texCoords);
	vec2 displacement = vec2(displacementPower * ((mapColor.g - 0.5) * 2.0));
	gl_FragColor = texture2D(u_diffuseTexture, v_texCoords + displacement);
	if(gl_FragColor.a == 0.0){discard;}

//	float factorX = _DisplacementPowerX * _texelSize.x;
//	float factorY = _DisplacementPowerY * _texelSize.y;
//
//	vec4 targetMaskValue = texture2D(_DisplacementTex, v_texCoords);
//
//	vec2 uvDisplaced = v_texCoords;
//	uvDisplaced.x = uvDisplaced.x - factorX * targetMaskValue.g; //((targetMaskValue.x - 0.5) * 2.0);
//	uvDisplaced.y = uvDisplaced.y - factorY * targetMaskValue.g; //((targetMaskValue.y - 0.5) * 2.0);
//
//	vec4 imageColor = texture2D(u_diffuseTexture, uvDisplaced);
//
//	gl_FragColor = imageColor;
}